//
//  TextView.swift
//  Do It
//
//  Created by Jim Dovey on 10/6/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import SwiftUI
import UIKit

struct TextView: UIViewRepresentable {
    @Binding var text: String
    
    var onEditingChanged: ((Bool) -> ())? = nil
    var onEditingCommit: (() -> ())? = nil
    
    func makeUIView(context: Context) -> UITextView {
        let view = UITextView()
        view.delegate = context.coordinator
        view.font = UIFont.preferredFont(forTextStyle: .body)
        view.textColor = UIColor.label
        
        return view
    }
    
    func updateUIView(_ uiView: UITextView, context: Context) {
        uiView.text = text
        uiView.textColor = .label
        
        let traits = UITraitCollection(traitsFrom: [
            uiView.traitCollection,
            UITraitCollection(swiftUIContentSizeCategory: context.environment.sizeCategory)
        ])
        uiView.font = UIFont.preferredFont(forTextStyle: .body, compatibleWith: traits)
    }
    
    func makeCoordinator() -> Coordinator {
        return Coordinator(self)
    }
    
    class Coordinator: NSObject, UITextViewDelegate {
        var parent: TextView
        
        init(_ parent: TextView) {
            self.parent = parent
        }
        
        func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
            print("\(#function)")
            return true
        }
        
        func textViewShouldBeginEditing(_ textView: UITextView) -> Bool {
            print("\(#function)")
            return true
        }
        
        func textViewDidChange(_ textView: UITextView) {
            print("\(#function)")
            self.parent.text = textView.text
        }
        
        func textViewDidBeginEditing(_ textView: UITextView) {
            print("\(#function)")
            parent.onEditingChanged?(true)
        }

        func textViewDidEndEditing(_ textView: UITextView) {
            print("\(#function)")
            parent.onEditingCommit?()
            parent.onEditingChanged?(false)
        }
    }
}

struct TextView_Previews: PreviewProvider {
    static var previews: some View {
        Group {
            StatefulPreviewWrapper("This is the sample text.\n\nIt has many lines.") {
                TextView(text: $0)
            }
            StatefulPreviewWrapper("This is the sample text.\n\nIt has many lines.") {
                TextView(text: $0)
                    .environment(\.colorScheme, .dark)
            }
        }
        .previewLayout(.fixed(width: 400, height: 200))
    }
}
